/****************************************************************************
*                                             COPYRIGHT (c) Freescale 2005   
* FILE NAME: s12xe_flash.h     REVISION 1.1                                                   
*                                                                           
* PURPOSE: header file for s12xe_flash.c      		 							 
*                                                                           
* DESCRIPTION:  definitions for S12XE flash routines 			 
*                                                                           
* AUTHOR: r32151    LOCATION: EKB       
*                                                                           
* UPDATE HISTORY                                                            
* REV      AUTHOR       DATE       DESCRIPTION OF CHANGE                    
* ---      ------      --------    ---------------------                    
* 1.0      r32151      17/11/05    - original coding                                                                   
* 1.1      r32151      21/11/05    - updated comment fields for some commands 
*                                  - updated the FCLK prescaler calculation                                                                
*                                                                           
******************************************************************************/                                                                        
/*===========================================================================*/
/* Freescale reserves the right to make changes without further notice to any*/
/* product herein to improve reliability, function, or design. Freescale does*/
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others. Freescale */
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where*/
/* personal injury or death may occur. Should Buyer purchase or use Freescale*/
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,*/
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale*/
/* was negligent regarding the  design  or manufacture of the part. Freescale*/
/* and the Freescale logo* are registered trademarks of Freescale Ltd.       */
/*****************************************************************************/

#ifndef S12XE_FLASH_H        /*prevent duplicated includes*/
#define S12XE_FLASH_H

/************************* Include Files *************************************/
#include "S12_COMMON.h"

/************************* #defines ******************************************/
#ifndef ALIGNED_WORD_MASK
#define ALIGNED_WORD_MASK	   0x0001
#define ALIGNED_PHRASE_MASK	0x0007
#define SIZEOF_PHRASE          8
#endif

#define FLASH_OK               0
#define FLASH_ADDRESS_ERROR    1
#define FLASH_ACCESS_ERROR     ACCERR
#define FLASH_BUSY             MGBUSY

/**** P-Flash and D-Flash Commands ****/

#define ERASE_VERIFY_ALL_BLOCKS  0x01 
/* Verify that all program and data Flash blocks are erased. */
/* CCOBIX end = 0 */
/* CCOB Params - NONE */
/* MGSTAT set if fault */

#define ERASE_VERIFY_BLOCK       0X02      
/* Verify that a Flash block is erased. */
/* CCOBIX end = 0 */
/* CCOB Params - gpage */
/* MGSTAT set if fault */

#define ERASE_ALL_BLOCKS         0x08 
/* Erase all program and data Flash blocks.
   An erase of all Flash blocks is only possible when the FPLDIS, FPHDIS, and FPOPEN
   bits in the FPROT register and the EPDIS and EPOPEN bits in the EPROM register are
   set prior to launching the command. */
/* CCOBIX end = 0 */
/* CCOB Params - NONE */
/* MGSTAT set if fault, FPVIOL / ACCERR set where appropriate */

#define UNSECURE_FLASH           0x0B 
/*Supports a method of releasing MCU security by erasing all program and data Flash
  blocks and verifying that all program and data Flash blocks are erased. */
/* CCOBIX end = 0 */
/* CCOB Params - NONE */
/* MGSTAT set if fault */

#define SET_USER_MARGIN_LEVEL    0x0D 
/*Specifies a user margin read level for all program Flash blocks. */
/* CCOBIX end = 1 */
/* CCOB Params - gpage, level setting (0-2) in CCOB[1] */
/* ACCERR set if invalid level */

#define SET_FIELD_MARGIN_LEVEL   0x0E 
/*Specifies a field margin read level for all program Flash blocks (special modes only). */
/* CCOBIX end = 1 */
/* CCOB Params - gpage, level setting (0-4) in CCOB[1] */
/* ACCERR set if invalid level */

/* **** P-Flash Only Commands ****/

#define ERASE_VERIFY_P_FLASH_SECTION 0x03  
/*Verify that a given number of words starting at the address provided are erased. */
/* CCOBIX end = 2 */
/* CCOB Params - global address, number of phrases in CCOB[2]*/
/* MGSTAT set if fault */

#define READ_ONCE	               0x04  
/* Read a phrase from a dedicated 64 word area in a hidden region of a programFlash block
   that was previously programmed using the Program Once command. */
/* CCOBIX end = 1 */
/* CCOB Params - read once index (0-3) in CCOB[1], phrase in CCOB [5:2] */
/* returns phrase in CCOB [4:1] */

#define LOAD_DATA_FIELD          0x05 
/* Load data for simultaneous multiple program Flash block operations. */
/* CCOBIX end = 5 */
/* CCOB Params - global address, phrase in CCOB [5:2]  */

#define PROGRAM_P_FLASH          0x06 
/* Program a phrase in a program Flash block and any previously loaded phrases for any
   other program Flash block (see Load Data Field command). */
/* CCOBIX end = 5 */
/* CCOB Params - global address, phrase in CCOB [5:2] */
/* MGSTAT set if fault, FPVIOL / ACCERR set where appropriate */

#define PROGRAM_ONCE             0x07 
/* Program a dedicated 64 word area in a hidden region of a program Flash block that is
   allowed to be programmed only once. */
/* CCOBIX end = 5 */
/* CCOB Params - read once index (0-3) in CCOB[1], phrase in CCOB [5:2] */
/* MGSTAT set if fault */

#define ERASE_P_FLASH_BLOCK      0x09 
/* Erase a program Flash block.
   An erase of the full program Flash block is only possible when FPLDIS, FPHDIS and
   FPOPEN bits in the FPROT register are set prior to launching the command. */
/* CCOBIX end = 1 */
/* CCOB Params - global address */
/* MGSTAT set if fault, FPVIOL / ACCERR set where appropriate */

#define ERASE_P_FLASH_SECTOR 0x0A 
/* Erase all bytes in a program Flash sector. */
/* CCOBIX end = 1 */
/* CCOB Params - global address */
/* MGSTAT set if fault, FPVIOL / ACCERR set where appropriate */

#define VERIFY_BACKDOOR_ACCESS_KEY 0x0C 
/*Supports a method of releasing MCU security by verifying a set of security keys. */
/* CCOBIX end = 4 */
/* CCOB Params - backdoor key in CCOB [1:4] */
/* ACCERR set if not verified */

/**** D-Flash Only Commands ****/

#define ENABLE_D_FLASH 0x0F 
/* Partition a section of D-Flash for user access and EEE. */
/* CCOBIX end = 2 */
/* CCOB Params - number of sectors for D-Flash in CCOB[1],  number of sectors for EEE in CCOB[2]*/
/* ACCERR set if fault */

#define ERASE_VERIFY_D_FLASH_SECTION 0x10 
/* Verify that a given number of words starting at the address provided are erased. */
/* CCOBIX end = 2 */
/* CCOB Params - global address of first word, number of words to verify CCOB[2]*/
/* MGSTAT set if fault */

#define PROGRAM_D_FLASH         0x11 
/* Program up to four words in the data Flash block (see Load Data Field command). */
/* CCOBIX end = 2 */
/* CCOB Params - global address, up to 4 data words in CCOB [2:5] */
/* MGSTAT set if fault, EPVIOL / ACCERR set where appropriate */

#define ERASE_D_FLASH_SECTOR    0x12 
/* Erase all bytes in a data Flash sector. */
/* CCOBIX end = 2 */
/* CCOB Params - global address */
/* MGSTAT set if fault, EPVIOL  set where appropriate */

#define ENABLE_EEPROM_EMULATION    0x13 
/* Requests the FTMSM to enable EEPROM emulation. */
/* CCOBIX end = 0 */
/* CCOB Params - NONE */

#define DISABLE_EEPROM_EMULATION   0x14 
/* Requests the FTMSM to suspend all current erase and program activity related to
   EEPROM emulation but leave current EEE tags set. */
/* CCOBIX end = 0 */
/* CCOB Params - NONE */

#define CANCEL_EEPROM_EMULATION    0x15 
/* Requests the FTMSM to suspend all current erase and program activity related to
   EEPROM emulation and clear all outstanding EEE tags. */
/* CCOBIX end = 0 */
/* CCOB Params - NONE */


   /* Macro to calculate the FLASH clock precaler as per data book. */
   /* This macro calculates the prescaler. */
   // ALREADY DECLARED ELSEWHERE
   
//#define FCLK_PRESCALER ((OSCCLK_FREQ_KHZ) * ((BUSCLK_FREQ_KHZ + 1000) / (BUSCLK_FREQ_KHZ * 1000)))
   /* Make sure FCLK is within specified end. */
//#define FCLK_FREQ_KHZ (OSCCLK_FREQ_KHZ / (1 + FCLK_PRESCALER)) 

//#if ((FCLK_FREQ_KHZ < 800) || (((FCLK_FREQ_KHZ * BUSCLK_FREQ_KHZ)/(FCLK_FREQ_KHZ + BUSCLK_FREQ_KHZ)) > 1200) | FCLK_PRESCALER > 0x3F))
//#error FLASH prescaler or clock out of end (2).
//#endif /* Incorrect FCLK frequency. */


/************************* typedefs ******************************************/

typedef unsigned int phrase[4];

/************************* Global Variables **********************************/

/************************* function prototypes *******************************/
#pragma CODE_SEG DEFAULT
void ConfigFCLKDIV(void);
tU08 LaunchFlashCommand(char params, tU08 command, tU08 ccob0, tU16 ccob1, tU16 ccob2, tU16 ccob3, tU16 ccob4, tU16 ccob5);
tU08 ProgP_FlashPhraseAtPtr(tU16 *__far progAdr, tU16 *data);
tU08 ProgP_FlashPhrase(tU08 gpage, tU16 addr, tU16 *data);
tU08 LoadP_FlashPhraseData(tU08 gpage, tU16 addr, tU16 *data);
#endif /* S12XE_FLASH_H */
